<?php
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';

$context = Context::getContext();
$id_shop = (int)$context->shop->id;

$count_disabled = 0;
$count_enabled = 0;

$sql = "SELECT DISTINCT p.id_product
        FROM "._DB_PREFIX_."product p
        INNER JOIN "._DB_PREFIX_."product_shop ps ON (p.id_product = ps.id_product AND ps.id_shop = $id_shop)";
$products = Db::getInstance()->executeS($sql);

foreach ($products as $row) {
    $id_product = (int)$row['id_product'];
    $product = new Product($id_product);

    $combinations = $product->hasAttributes() ? Product::getProductAttributesIds($id_product) : [];

    $has_stock = false;

    if (!empty($combinations)) {
        foreach ($combinations as $combination) {
            $id_product_attribute = (int)$combination['id_product_attribute'];
            $qty = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, $id_shop);
            if ($qty > 0) {
                $has_stock = true;
                break;
            }
        }
    } else {
        $qty = StockAvailable::getQuantityAvailableByProduct($id_product, 0, $id_shop);
        $has_stock = ($qty > 0);
    }

    if ($has_stock && !$product->active) {
        $product->active = 1;
        $product->save();
        $count_enabled++;
    } elseif (!$has_stock && $product->active) {
        $product->active = 0;
        $product->save();
        $count_disabled++;
    }
}

echo "Processing complete. Products disabled: $count_disabled | Products re-enabled: $count_enabled";
