<?php
/**
 * Plugin Name: Gravity Forms Auto Login
 * Description: Connecte automatiquement un utilisateur après inscription via Gravity Forms User Registration.
 * Version: 1.2
 * Author: KPICREATION
 */

// Désactiver le traitement asynchrone des feeds 
add_filter('gform_is_feed_asynchronous', '__return_false');

// Connexion automatique après inscription
add_action('gform_user_registered', 'gf_auto_login_after_registration', 10, 4);
function gf_auto_login_after_registration($user_id, $feed, $entry, $password) {
    if (!is_user_logged_in()) {
        $user = get_userdata($user_id);
        $creds = array(
            'user_login'    => $user->user_login,
            'user_password' => $password,
            'remember'      => true
        );
        wp_signon($creds, false);
    }
}
