<?php
/*
Plugin Name: Synchronisation Achat de Rôle UM/WooCommerce
Description: Permet d’associer dynamiquement un produit WooCommerce à un rôle Ultimate Member via le back-office. Idéal pour vendre des accès par rôle UM.
Version: 1.0
Author: KPICREATION
*/

if (!defined('ABSPATH')) exit;

// Ajout menu “Réglages » Synchronisation Achat de Rôle”
add_action('admin_menu', function() {
    add_options_page(
        'Synchronisation Achat de Rôle UM/WooCommerce',
        'Synchronisation Achat de Rôle',
        'manage_options',
        'synchro-achat-role-um-woocommerce',
        'saruw_affiche_page'
    );
});

function saruw_affiche_page() {
    if (!current_user_can('manage_options')) return;

    // Ajout
    if (isset($_POST['saruw_ajouter_association']) && check_admin_referer('saruw_ajout_association')) {
        $prod_id = intval($_POST['saruw_produit_id']);
        $role_slug = sanitize_text_field($_POST['saruw_role_slug']);
        if ($prod_id && $role_slug) {
            $assos = get_option('saruw_assos_prod_role', []);
            $assos[$prod_id] = $role_slug;
            update_option('saruw_assos_prod_role', $assos);
            echo '<div class="notice notice-success is-dismissible"><p>Association ajoutée.</p></div>';
        }
    }

    // Suppression
    if (isset($_GET['saruw_supprimer']) && check_admin_referer('saruw_suppr_'.intval($_GET['saruw_supprimer']))) {
        $assos = get_option('saruw_assos_prod_role', []);
        unset($assos[intval($_GET['saruw_supprimer'])]);
        update_option('saruw_assos_prod_role', $assos);
        echo '<div class="notice notice-success is-dismissible"><p>Association supprimée.</p></div>';
    }

    // Récupération des produits WooCommerce
    $products = class_exists('WooCommerce')
        ? wc_get_products(['status'=>['publish'],'limit'=>-1,'return'=>'objects'])
        : [];

    $assos = get_option('saruw_assos_prod_role', []);
    ?>
    <div class="wrap">
      <h1>Synchronisation Achat de Rôle UM/WooCommerce</h1>
      <p>Associez chaque produit WooCommerce à un rôle Ultimate Member. Idéal pour vendre des accès premium ou des abonnements à vos membres UM.</p>
      <form method="post">
        <?php wp_nonce_field('saruw_ajout_association'); ?>
        <table class="form-table">
          <tr>
            <th>Produit WooCommerce</th>
            <td>
              <select name="saruw_produit_id" required>
                <option value="">-- Sélectionner --</option>
                <?php foreach ($products as $p): ?>
                  <option value="<?= esc_attr($p->get_id()) ?>"><?= esc_html($p->get_name().' (ID '.$p->get_id().')') ?></option>
                <?php endforeach; ?>
              </select>
            </td>
          </tr>
          <tr>
            <th>Slug du rôle UM</th>
            <td><input type="text" name="saruw_role_slug" placeholder="ex: um_utilisateur-basic" required /></td>
          </tr>
        </table>
        <p><button type="submit" name="saruw_ajouter_association" class="button button-primary">Ajouter</button></p>
      </form>

      <h2>Associations existantes</h2>
      <table class="widefat">
        <thead><tr><th>ID Produit</th><th>Nom</th><th>Slug du rôle UM</th><th>Action</th></tr></thead>
        <tbody>
        <?php if ($assos): foreach ($assos as $pid => $slug): 
            $p = wc_get_product($pid); ?>
          <tr>
            <td><?= esc_html($pid) ?></td>
            <td><?= $p ? esc_html($p->get_name()) : '<i>Non trouvé</i>' ?></td>
            <td><?= esc_html($slug) ?></td>
            <td>
              <?php
                $url = admin_url('options-general.php?page=synchro-achat-role-um-woocommerce'
                       . '&saruw_supprimer='.$pid
                       . '&_wpnonce='.wp_create_nonce('saruw_suppr_'.$pid));
              ?>
              <a href="<?= esc_url($url) ?>" class="button button-small"
                 onclick="return confirm('Supprimer ?');">Supprimer</a>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr><td colspan="4">Aucune association.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
    <?php
}

// Récupération dynamique 
function saruw_get_associations() {
    return get_option('saruw_assos_prod_role', []);
}

